#ifndef CHANNELS_H_
#define CHANNELS_H_

#include <stdint.h>
#include "Wavetable.h"

class Channels {
private:
    uint8_t volume[16];
    uint8_t expression[16];
    int16_t pitchBend[16];
    Wavetable::wave_t wave[16];

public:
    Channels();
    ~Channels();
    void initializeAll();
    void setVolume(uint8_t, uint8_t);
    void setExpression(uint8_t, uint8_t);
    void setPitchBend(uint8_t, int16_t);
    void setWave(uint8_t, Wavetable::wave_t);
    
    uint8_t getVolume(uint8_t);
    uint8_t getExpression(uint8_t);
    int16_t getPitchBend(uint8_t);
    Wavetable::wave_t getWave(uint8_t);
};

#endif
