#include "defs.h"
#include "Channels.h"

/** Constructor of class Channels */
Channels::Channels() {
}

/** Destructor of class Channels */
Channels::~Channels() {
}

/** Initialize all 16 channels */
void Channels::initializeAll() {
    for (uint8_t i = 0; i < 16; i++) {
        this->volume[i] = 100;
        this->expression[i] = 127;
        this->pitchBend[i] = 0;
        this->wave[i] = Wavetable::waveDefList[4];
    }
}

/** Set volume to channel #i (i: zero origin) */
void Channels::setVolume(uint8_t i, uint8_t vo) {
    this->volume[i] = vo;
}

/** Set expression to channel #i (i: zero origin) */
void Channels::setExpression(uint8_t i, uint8_t ex) {
    this->expression[i] = ex;
}

/** Set pitch bend to channel #i (i: zero origin) */
void Channels::setPitchBend(uint8_t i, int16_t pb) {
    this->pitchBend[i] = pb;
}

/** Set wave parameters of channel #i (i: zero origin) */
void Channels::setWave(uint8_t i, Wavetable::wave_t w) {
    this->wave[i] = w;
}

/** Get volume of channel #i (i: zero origin) */
uint8_t Channels::getVolume(uint8_t i) {
    return this->volume[i];
}

/** Get expression of channel #i (i: zero origin) */
uint8_t Channels::getExpression(uint8_t i) {
    return this->expression[i];
}

/** Get pitch bend of channel #i (i: zero origin) */
int16_t Channels::getPitchBend(uint8_t i) {
    return this->pitchBend[i];
}

/** Get wave parameters of channel #i (i: zero origin) */
Wavetable::wave_t Channels::getWave(uint8_t i) {
    return this->wave[i];
}
