#include <stdint.h>
#include <stdlib.h>
#include "Conway.h"

#define MOD_8(i)          ((i) - (((i) >> 3) << 3))
#define WORLD(x, y)       ((world[(y)][(x) >> 3] & (1 << (7 - MOD_8(x)))) > 0 ? 1 : 0)
#define WORLDT_ADDR(x, y) worldTemp[(y)][(x) >> 3]

void Conway::nextGeneration() {
    uint8_t left;
    uint8_t right;
    uint8_t up;
    uint8_t down;
    uint8_t numAlive;
    
    initWorldTemp();
    
    for (uint8_t j = 0; j < 128; j++) {
        up   = j == 0 ? 127 : j - 1;
        down = j == 127 ? 0 : j + 1;
        
        for (uint8_t i = 0; i < 128; i++) {
            left  = i == 0 ? 127 : i - 1;
            right = i == 127 ? 0 : i + 1;
            
            // Count alive cells
            numAlive =   WORLD(left, up)   + WORLD(i, up)   + WORLD(right, up)
                       + WORLD(left, j)                     + WORLD(right, j)
                       + WORLD(left, down) + WORLD(i, down) + WORLD(right, down);
            
            if (numAlive == 3) {
                WORLDT_ADDR(i, j) |= 1 << (7 - MOD_8(i));
            } else if (numAlive == 2) {
                WORLDT_ADDR(i, j) |= WORLD(i, j) << (7 - MOD_8(i));
            }
        }
    }
}

void Conway::swap() {
    for (uint8_t j = 0; j < 128; j++) {
        for (uint8_t i = 0; i < 16; i++) {
            if (world[j][i] != worldTemp[j][i]) {
                world[j][i] ^= worldTemp[j][i];
                worldTemp[j][i] ^= world[j][i];
                world[j][i] ^= worldTemp[j][i];
            }
        }
    }
}

void Conway::initWorldTemp() {
    for (uint8_t j = 0; j < 128; j++) {
        for (uint8_t i = 0; i < 16; i++) {
            worldTemp[j][i] = 0x00;
        }
    }
}

void Conway::randomizeWorld(uint16_t seed) {
    srand(seed);
    
    for (uint8_t j = 0; j < 128; j++) {
        for (uint8_t i = 0; i < 16; i++) {
            world[j][i] = rand() ^ (rand() >> 4);
        }
    }
}

void Conway::randomizeWorld25(uint16_t seed) {
    srand(seed);
    
    for (uint8_t j = 0; j < 128; j++) {
        for (uint8_t i = 0; i < 16; i++) {
            world[j][i] = rand() & (rand() >> 4);
        }
    }
}

void Conway::randomizeWorld75(uint16_t seed) {
    srand(seed);
    
    for (uint8_t j = 0; j < 128; j++) {
        for (uint8_t i = 0; i < 16; i++) {
            world[j][i] = rand() | (rand() >> 4);
        }
    }
}
