// ==================================================== Mar 19 2014, kayeks ==
// ACM1602.cpp
// ===========================================================================
// Displaytronic (Xiamen Zettler)'s I2C text LCD driver

#ifndef ACM1602_H_
#define ACM1602_H_

class ACM1602 : public Stream {
private:
    I2C     i2c;
    uint8_t address;
    int     col, row;
    uint8_t lineBuffer[2][16];
    
public:
    ACM1602(PinName sda, PinName scl, uint8_t address);
    void init();
    void cls();
    void locate(int col, int row);
    
private:
    virtual int _putc(int c);
    virtual int _getc();
    void shiftUp();
    void command(uint8_t b);
    void data(uint8_t b);
};

#endif
