#include "mbed.h"
#include "MaxbotixLV.h"

MaxbotixLV::MaxbotixLV(PinName analogIN):
        _analogIn(analogIN) {
    _voltIn = 3.300;
    _scaler = 0.0098;
}

void MaxbotixLV::setVoltage(float voltIn) {
    _voltIn = (voltIn);
}

void MaxbotixLV::setScale(float scaler) {
    _scaler = (scaler);
}

float MaxbotixLV::getInches() {

    float reading = _analogIn.read();
    float Avolts = reading * _voltIn;
    return (Avolts / _scaler);
}

float MaxbotixLV::getAnalog() {
    return _analogIn.read();
}


