#include "DCMotor.h"
#include "mbed.h"

DCMotor::DCMotor(PinName PWMPin, PinName PinA, PinName PinB):
    _PWMPin(PWMPin), _PinA(PinA), _PinB(PinB) {
    
    _PWMPin.period(0.001);
    _PWMPin = 0;
    
    _PinA = 0;
    _PinB = 0;
}

void DCMotor::driveIt(float perCent) {
    if (perCent > 0) {
        _PinA = 0;
        _PinB = 1;
        
    } else {
        _PinA = 1;
        _PinB = 0;
    }
    _PWMPin = fabs(perCent/100);    
}