#include "mbed.h"

//LEDs to indicate key presses
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

//init serial trx throught USB
Serial pc(USBTX, USBRX);

//init 1 sec timer
Ticker secs;

//variables
char x,y,z,t,u,min = 0,sec = 0,hr = 0;

//mytick give a second of delay and print the time out.
void mytick() {
    sec++;
    if (sec >= 59) {
        sec = 0;
        min ++;
        if (min >= 59) {
            min = 0;
            hr ++;
            if (hr >= 23) {
                hr = 0;
            }
        }
    }
    pc.printf(" %d:%d:%d   \r",hr,min,sec);
}

//software entry point
void main(void){
    //print general details
    pc.printf("hour up/down = q/a\n\r");
    pc.printf("minute up/down = w/s\n\r");
    pc.printf("second up/down = e/d\r\n\n\n");
    //activate the timer
    secs.attach(&mytick,1);

    //do forever
    while (1) {

        myled1 = 0;
        myled2 = 0;
        myled3 = 0;
        //if any key is pressed, enter this portion of code
        if (pc.readable() == 1) {
            //get the character
            char ch = pc.getc();
            switch (ch) {
                case 'q':
                    if (hr >= 23)
                        hr =0;
                    myled1 = 1;
                    hr++;
                    pc.printf(" %d:%d:%d   \r",hr,min,sec);
                    break;
                case 'a':
                    if (hr >= 23)
                        hr =0;
                    myled1 = 1;
                    hr--;
                    pc.printf(" %d:%d:%d   \r",hr,min,sec);
                    break;
                case 'w':
                    if (min >= 59)
                        min =0;
                    myled2 = 1;
                    min++;
                    pc.printf(" %d:%d:%d   \r",hr,min,sec);
                    break;
                case 's':
                    if (min >= 59)
                        min =0;
                    myled2 = 1;
                    min--;
                    pc.printf(" %d:%d:%d   \r",hr,min,sec);
                    break;
                case 'e':
                    if (sec >= 59)
                        sec =0;
                    myled3 = 1;
                    sec++;
                    pc.printf(" %d:%d:%d   \r",hr,min,sec);
                    break;
                case 'd':
                    if (sec >= 59)
                        sec =0;
                    myled3 = 1;
                    sec--;
                    pc.printf(" %d:%d:%d   \r",hr,min,sec);
                    break;
            }
        }
    }
}
