#ifndef MY_SHAPE
#define MY_SHAPE

#include "mbed.h"

/**
* A library to create square and rectangle objects. calculates the area and perimeter
* 
* Example:
* @code 
* 
* #include "mbed.h"
* #include "Shape.h"
* 
* Shape rect(3,4);
* Shape squr(1);
* 
* int main() {
*     printf(" area of rect = %d \n", rect.getArea());
*     printf("perimeter of square = %d \n", squr.getPerimeter());
* }
* 
* @endcode
* 
*/

class Shape{
    public:
        /**  create an object for square
        *   @param x    integer value for a side on square
        */
        Shape(int x);
        
        
        /**  create an object for rectangle
        *   @param x    integer value for length of rectangle
        *   @param y    integer value for breadth of rectangle
        */
        Shape(int x, int y);
        
        /**  returns to area of rectangle/square
        *   @return     returns the area of rectangle/square
        */
        int getArea();
        
        
        /**  returns to perimeter of rectangle/square
        *   @return     returns the perimeter of rectangle/square
        */
        int getPerimeter();
        
    private:
        int _x;
        int _y;
        int _area;
        int _perim;
};

#endif