#ifndef MBED_ENCODER_H
#define MBED_ENCODER_H

#include "mbed.h"

class quadratureEncoder {
public:
    quadratureEncoder(PinName pinA, PinName pinB);
    int getCount();
    int getMoved();
    
    void resetCount();
    void resetMoved();
    void setCount(int setCounter);
    void setMoved(int setCounter);
    
private:
    void ARise(void);
    void BRise(void);
    void AFall(void);
    void BFall(void);
    char saveState(char nowS);
    char getBit(char bitP, char targB);
    
    InterruptIn _pinA;
    InterruptIn _pinB;
    char _oldState, _nowState;
    int _moved;
    int _count;
};


#endif