#ifndef MBED_DCMOTOR_H
#define MBED_DCMOTOR_H

#include "mbed.h"

/**DC motor control class with PWM control
*
* Example:
* @code
* 
* #include "mbed.h"
* #include "DCMotor.h"
* 
* DCMotor a(p21,p22,p23);
* DCMotor b(p24,p25,p26);
* int main() {
*     a.driveIt(50);
*     b.driveIt(50);
* }
* 
* @endcode 
*/

class DCMotor {

public:
    /** create a DCMotor object connected to the pins with speed control
    *   @param PWMPin   PWM pin to control speed of motor
    *   @param PinA     Digital output pin to connect to motor
    *   @param PinB     Digital output pin to connect to motor
    */
    DCMotor(PinName PWMPin, PinName PinA, PinName PinB);
    
    /** drive Motor input range (-100 to 100).
    *   @param perCent   PWM pin to control speed of motor
    */
    void driveIt(float);

protected:
    PwmOut _PWMPin;
    DigitalOut _PinA;
    DigitalOut _PinB;
};

#endif