/*
# This file is Copyright 2009 Dean Hall.
#
# This file is part of the Python-on-a-Chip program.
# Python-on-a-Chip is free software: you can redistribute it and/or modify
# it under the terms of the GNU LESSER GENERAL PUBLIC LICENSE Version 2.1.
# 
# Python-on-a-Chip is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# A copy of the GNU LESSER GENERAL PUBLIC LICENSE Version 2.1
# is seen in the file COPYING up one directory from this.
*/


#include "pm.h"

#if defined(TARGET_LPC1768)
#define HEAP_SIZE 0x7000
#define USRLIB_IMG (uint8_t*)77824

#elif defined(TARGET_LPC1549)
#define HEAP_SIZE 0x8000
#define USRLIB_IMG (uint8_t*)61440

#elif defined(TARGET_KL46Z)
#define HEAP_SIZE 0x7000
#define USRLIB_IMG (uint8_t*)73728

#elif defined(TARGET_KL25Z)
#define HEAP_SIZE 0x3400
#define USRLIB_IMG (uint8_t*)73728

#elif defined(TARGET_LPC4088)
#define HEAP_SIZE 0xf000
#define USRLIB_IMG (uint8_t*)73728

#elif defined(TARGET_NUCLEO_F401RE)
#define HEAP_SIZE 0x15000
#define USRLIB_IMG (uint8_t*)69632

#elif defined(TARGET_LPC11U68)
#define HEAP_SIZE 0x7000
#define USRLIB_IMG (uint8_t*)61440

#elif defined(TARGET_NUCLEO_F411RE)
#define HEAP_SIZE 0x1f000
#define USRLIB_IMG (uint8_t*)69632

#elif defined(TARGET_NUCLEO_F103RB)
#define HEAP_SIZE 0x4000
#define USRLIB_IMG (uint8_t*)69632

#elif defined(TARGET_NUCLEO_L152RE)
#define HEAP_SIZE 0x12000
#define USRLIB_IMG (uint8_t*)69632

#else
#error "target error"
#endif

uint8_t heap[HEAP_SIZE];

int
main(void)
{
    PmReturn_t retval;

    retval = pm_init(heap, HEAP_SIZE, MEMSPACE_PROG, USRLIB_IMG);
    PM_RETURN_IF_ERROR(retval);

    /* Run the sample program */
    retval = pm_run((uint8_t *)"main");

    return (int)retval;
}
