// NativeClassInterface.cpp 2013/3/13
#include "mbed.h"
#define __DEBUG__ 1
#include "pm.h"
#include "NativeClassInterface.h"
#include "PinNameTable.h"

#undef __FILE_ID__
#define __FILE_ID__ 0x71

template<>
int NativeClassInterface::argv<int>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    if (OBJ_GET_TYPE(pn) == OBJ_TYPE_STR) {
        return ((pPmString_t)pn)->val[0];
    }
    return ((pPmInt_t)pn)->val;
}

template<>
bool NativeClassInterface::argv<bool>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    return ((pPmInt_t)pn)->val;
}

template<>
float NativeClassInterface::argv<float>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    return ((pPmFloat_t)pn)->val;
}

template<>
char NativeClassInterface::argv<char>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    return ((pPmString_t)pn)->val[0];
}

template<>
char* NativeClassInterface::argv<char*>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    return reinterpret_cast<char*>(((pPmString_t)pn)->val);
}

template<>
const char* NativeClassInterface::argv<const char*>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    return reinterpret_cast<const char*>(((pPmString_t)pn)->val);
}

template<>
uint16_t NativeClassInterface::argv<uint16_t>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    return ((pPmInt_t)pn)->val;
}

template<>
PinName NativeClassInterface::argv<PinName>(int n)
{
    pPmObj_t pn = NATIVE_GET_LOCAL(n);
    if (OBJ_GET_TYPE(pn) == OBJ_TYPE_INT) {
        return (PinName)(((pPmInt_t)pn)->val);
    }
    if (OBJ_GET_TYPE(pn) != OBJ_TYPE_STR) {
        return NC;
    }       
    int imin = 0;
    int imax = sizeof(pinname_table) / sizeof(pinNameStr) - 1;
    char *key = reinterpret_cast<char*>(((pPmString_t)pn)->val);
    while(imax >= imin) {
        int i = (imin + imax) / 2;
        int c = strcmp(key, pinname_table[i].name);
        if (c == 0) {
            return pinname_table[i].pin;
        } else if (c > 0) {
            imin = i + 1;
        } else {
            imax = i - 1;
        }
    }
    return NC;
}

template<>
PmReturn_t NativeClassInterface::set_return_value<int>(PmType_t ret_type, int value)
{
    pPmObj_t pn;
    PmReturn_t retval;
    if (ret_type == OBJ_TYPE_STR) {
        retval = string_newFromChar((uint8_t)value, &pn);
    } else {
        retval = int_new(value, &pn);
    }
    NATIVE_SET_TOS(pn);
    return retval;
}

template<>
PmReturn_t NativeClassInterface::set_return_value<uint8_t>(PmType_t ret_type, uint8_t value)
{
    pPmObj_t pn;
    PmReturn_t retval = int_new(value, &pn);
    NATIVE_SET_TOS(pn);
    return retval;
}

template<>
PmReturn_t NativeClassInterface::set_return_value<uint16_t>(PmType_t ret_type, uint16_t value)
{
    pPmObj_t pn;
    PmReturn_t retval = int_new(value, &pn);
    NATIVE_SET_TOS(pn);
    return retval;
}

template<>
PmReturn_t NativeClassInterface::set_return_value<float>(PmType_t ret_type, float value)
{
    pPmObj_t pn;
    PmReturn_t retval = float_new(value, &pn);
    NATIVE_SET_TOS(pn);
    return retval;
}

template<typename R>
PmReturn_t NativeClassInterface::set_return_value(PmType_t ret_type, R value)
{
    pPmObj_t pn;
    PmReturn_t retval;
    switch(ret_type) {
       case OBJ_TYPE_INT:
            retval = int_new(value, &pn);
            break;
        case OBJ_TYPE_FLT:
            retval = float_new(value, &pn);
            break;
    }
    NATIVE_SET_TOS(pn);
    return retval;
}

PmReturn_t NativeClassInterface::check_argv_type(int arg_n, ...)
{
    PmReturn_t retval = PM_RET_OK;
    if (NATIVE_GET_NUM_ARGS() != (arg_n+1)) {
        PM_RAISE(retval, PM_RET_EX_TYPE);
        return retval;
    }
    va_list vl;
    va_start(vl, arg_n);
    for(int n = 1; n <= arg_n; n++) {
        pPmObj_t pn = NATIVE_GET_LOCAL(n);
        int ty = va_arg(vl, int);
        if (OBJ_GET_TYPE(pn) != ty) {
            PM_RAISE(retval, PM_RET_EX_TYPE);
            return retval;
        }
    }
    return retval;
}
