#include "mbed.h"
#include "MODSERIAL.h"

//globals for stick inputs and led outputs
AnalogIn topStickVert(p15);
AnalogIn topStickHorz(p16);
AnalogIn botStickVert(p17);
AnalogIn botStickHorz(p18);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);


//xBee
Serial pc(USBTX, USBRX); // tx, rx
Serial xbee(p13, p14); //tx, rx
DigitalOut rstXbee(p21);

/**
* funtion to send data
*/
void xbeeSend(char data1, char data2)
{
        //send the preamble
        xbee.putc(0xA1);
        xbee.putc(0xB2);
        //send the header
        xbee.putc(0x02);
        //send the data
        xbee.putc(data1);
        xbee.putc(data2);
        //checksum?

    
}

int main() {

    //reset the xbee
    rstXbee = 0;
    wait_ms(1); 
    rstXbee=1;
    wait_ms(1);
    //LED verification
    myled1 = 1;
    wait(0.1);
    myled2 = 1;
    myled1 = 0;
    wait(0.1);
    myled2=0;
    
    //variables
    int right;
    int left;
    
    while(1) 
    {
    
        pc.printf("READY!... ");
        /*
        pc.printf("Top VERT: %f    ", topStickVert.read());
        pc.printf("Top HORZ: %f    ", topStickHorz.read());
        pc.printf("Bot VERT: %f    ", botStickVert.read());
        pc.printf("Bot HORZ: %f    \r\n", botStickHorz.read());*/
        
        int right = topStickVert.read()*256;
        int left = botStickVert.read()*256;
        xbeeSend(right, left);
        
        
    }
    
}