/** example program for the use of the MCP4728 class and DACInterface.h classes
 *
 *  V 1.0  : tested on the KL05z  but without the MCP4728 connected \
 * (C) Wim Beaumont Universiteit Antwerpen 2016 
 */ 

#define MCP4728EXAMPLEVER "1.10                    "

#include "mbed.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif


#include "I2C.h"
#include "I2CInterface.h" 
#include "MBEDI2CInterface.h" 
#include "DACInterface.h" 
#include "dev_interface_def.h"
#include "mcp4725.h"

MBEDI2CInterface mbedi2c( SDA, SCL); 
//MBEDI2CInterface* mbedi2cp=  &mbedi2c ;
I2CInterface* i2cdev= &mbedi2c;
const float Vdd=5.0;

Serial pc(USBTX, USBRX);

int main(void) {
  
    // Get the version of getVersion 
    getVersion gv;
    printf("MCP4725 example program version %s, compile date %s time %s\n\r",MCP4728EXAMPLEVER,__DATE__,__TIME__);
    printf("getVersion :%s\n\r",gv.getversioninfo());
    
    MCP4725 dac(&mbedi2c ,0, Vdd);  // assuming the address of the MCP4725 is set to 0 factory default 
    printf("MCP4725 :%s\n\r",dac.getversioninfo());
    wait(4);
    
    float voltage=0;
    int cnt=0;
    while(cnt < 4096){
        // first set the 4 channels 
        for ( int cc =0 ; cc <4 ; cc++) { 
            if ( !dac.setDACvalue(cnt,cc) )
                printf("failed to set dac value %d for channel %d\n\r",cnt,cc);
        }
        printf("DAC value:");
        int value = 0;
        for (int i = 0; i < 15; i++) {
            if (dac.getDACvalue(value))
                printf(" %d", value);
        }
        printf("\n\rset DAC value  to %d result in",cnt);
            // no else read anyway even if set fails 
        if(dac.update())
            printf("\n\rfailed to readback channel info \n\r");
        else {
            for ( int cc =0 ; cc <4 ; cc++) { 
                dac.getVoltage(voltage,cc);//no need to test done with update
                printf(" CH%d %f[V]",cc,voltage);
            }
            printf("\n\r");
        }
        cnt++;
        cnt=cnt % 4096;     
        wait_ms(500);
    }
    
    // now the same with the DAC interface 
    DACInterface* di = &dac;
    cnt=0;
    while(1){
        // first set the 4 channels 
        for ( int cc =0 ; cc <4 ; cc++) { 
            if ( di->setDACvalue(cnt,cc) == 0)
                printf("failed to set dac value %d for channel %d\n\r",cnt,cc);
        }
        printf("set DAC value  to %d result in",cnt);
        // no else read anyway even if set fails 
        if(di->update())
            printf("\n\rfailed to readback channel info \n\r");
        else {
            for ( int cc =0 ; cc <4 ; cc++) { 
                (void)di->getVoltage(voltage,cc);// no need to test done with update
                printf(" CH%d %f[V]",cc,voltage);
            }
            printf("\n\r");
        }
        cnt++;
        cnt=cnt % 4096;     
        wait_ms(500);
    }
    
    // never reach this   
    return 1;
}   
