/*
Bluetooth to HD44780 (via Android Blutooth TerminL)
Kate Barnes
JY-MCU Bluetooth Module, 4-line HD44780 compatible LCD,
STM32F407VE Development Board
*/

#include "mbed.h"
#include "TextLCD.h"

Serial pc(PA_9, PA_10);  // tx, rx. To terminal
Serial pc2(PA_2, PA_3);  // tx, rx. To bluetooth board
 
int main() {
    TextLCD lcd(PE_2,PE_3,PE_4,PE_5,PE_6,PE_7, TextLCD::LCD20x4);
    // Define custom character and assign it to '\1'
    char square[]={ 0x0,0x1f,0x11,0x11,0x11,0x1f,0x0,0x0 };
    lcd.defineChar(1, square);

    pc.baud(57600);
    pc.printf("Serial terminal online\r\n");
    pc.printf("SystemCoreClock is %d MHz\r\n", (SystemCoreClock/1000000));
    
    pc2.baud(9600); // linvor bluetooth module default baud rate
    //pc2.printf("AT");    
    //wait(1);
    //if(pc2.readable()) 
    //{
     //   pc.putc(pc2.getc());
    //}
    lcd.printf("  \1 BT Receiver \1");
    lcd.printf("                    ");
    lcd.printf("                    ");
    lcd.printf("       \1 Barnes \1");
    wait(2);
    lcd.cls();
    while (1) 
    {
        if(pc2.readable()) 
        {
            char SChar = pc2.getc();
            pc.putc(SChar);
            lcd.putc(SChar);
        }
    }
}
