#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/HeartRateService.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"
#include "rtos.h"
#include <string.h>
#include "SDFileSystem.h"
#define E 0xEE
Semaphore one_slot(1);
 
BLE  ble;
const GapScanningParams scanningParams;

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params){
    BLE &ble= params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }
    const uint8_t address1[] = {E,E,E,E,E,E};
    ble.gap().setAddress(BLEProtocol::AddressType::PUBLIC, address1);
//  ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
//   ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
//   ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
}
 
int main (void) {
    ble.init(bleInitComplete);
    ble.setScanParams(GapScanningParams::SCAN_INTERVAL_MAX,
                      GapScanningParams::SCAN_WINDOW_MAX,
                      0);
while(true)ble.gap().startAdvertising();//BLEの送信


}
