#include "mbed.h"
#include "DHT.h"
#include "TextLCD.h"    // LCD1602
 
DHT sensor(PB_3, DHT11);
Serial pc(SERIAL_TX, SERIAL_RX);
 
 // LCD pins
TextLCD lcd(D2, D3, D9, D10, D11, D12);

// diplay text on LCD
void textLCD(char *text, int line) {
    char tmpBuf[16];
    for (int i = 0; i < 16; i++) tmpBuf[i] = 0x20;
    for (int i = 0; i < strlen(text); i++) {
        if (i < 16) tmpBuf[i] = text[i];
    }
    
    lcd.locate(0, line);
    lcd.printf(tmpBuf);
}


int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    pc.baud(9600);
    lcd.cls();
    char tmpString[16];
    char tmpString2[16];
    int iKey = 0;
    int oldiKey = 0;
    int temp_format = 0;
    int humid_format = 0;
    
    while(1) {  
        wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            pc.printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\r\n", k, c, f);
            pc.printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\r\n", h, dp, dpf);
            pc.printf("Tempformat: %d HumidFormat: %d\r\n", temp_format, humid_format);
            switch(temp_format) {
                case 0 : sprintf(tmpString, " Temp: %4.2fC", c); break;
//                case 1 : sprintf(tmpString, " Temp: %4.2fF", f); break;
//                case 2 : sprintf(tmpString, " Temp: %4.2fK", k); break;
            }     
            textLCD(tmpString, 1);
            switch(humid_format) {
                case 0 : sprintf(tmpString2, "Humid: %4.2f", h); break;
//                case 1 : sprintf(tmpString2, "Dewpoint: %4.2f", dp); break;
//                case 2 : sprintf(tmpString2, "DewpFast: %4.2f", dpf); break;
            }                   
            textLCD(tmpString2, 0);            
        } else {
            pc.printf("Error: %d\n", error);
            textLCD("Error", 0);
        }
    }
}