#include "mbed.h"
#define smp 2778  //2778 or 10000  
#define ecgsize 3600  //1000 or 7200

LocalFileSystem local("local");
AnalogOut analog_out(p18);
PwmOut pwm_out(LED2);

int main() {
  float sample[ecgsize];
  FILE *fp = fopen("/local/data.txt","r"); // ECG_n
  for (int i = 0; i < ecgsize; i++) {
    // 7200 or 1000
    fscanf(fp, "%f", &sample[i]);
  }
  fclose(fp);

  for (;;) {
    for (int i = 0; i < ecgsize; i++) {
      analog_out.write(sample[i]);
      pwm_out = sample[i];
      wait_us(smp);
    }
  }
}
