// Author: kasturir@ucla.edu (Kasturi Rangan Raghavan)
// \file
// QRSDet library ported to OOP
// Allows easy adjustment of sampling rates

#include <mbed.h>
#include <scmRTOS.h>
#include <qrsdet/qrsdet2-inl.h>

AnalogIn ecg_in(p20);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
PwmOut led3(LED3);
DigitalOut led4(LED4);


typedef OS::process<OS::pr0, 200> TEcgSampler;

TEcgSampler EcgSampler;

OS::TEventFlag ecg_sampler_ef;

int main() {
    OS::Run();
}

template<> OS_PROCESS void TEcgSampler::Exec() {
  float float_val;
  int int_val;
  qrsdet::QRSFilterParams qrs_filter_params(8.0);
  qrsdet::QRSDet2 *qrs_filter =
    new qrsdet::QRSDet2(qrs_filter_params);
  qrsdet::DelayFilter *delay_filter = new qrsdet::DelayFilter(45);
  for(;;) {
    ecg_sampler_ef.Wait();
    led2 = !led2;
    float_val = ecg_in.read();
    int_val = float_val * 128;
    int qrs_val = qrs_filter->Process(int_val);
    int delay_val = delay_filter->Process(int_val);
    led3 = delay_val/128.0;
    if (qrs_val > 0) led4 = !led4;
    
  }
}

void OS::SystemTimerUserHook() {
    static int cnt=0;
    if (++cnt == 8) {
        cnt = 0;
        led1 = !led1;
        ecg_sampler_ef.Signal();
    }
}

void OS::IdleProcessUserHook() {
    __WFI();
}
