// Author: kasturir@ucla.edu (Kasturi Rangan Raghavan)
// \file
// QRSDet library for QRS delays
// Very naive and basic implementation to demonstrate
// QRS code ported from QRSDet.
//
// Note:
//   Change both the wait_us and qrsdet::SAMPLE_RATE (in qrsdet-params.h)
//   to adjust to different sampling rates. Currently set up for 125Hz
// Also, the offset/scale for reading ADC input may have to be adjusted
//
// Note2:
// Since function are not pure, local variables stored as static, 
// That means the filter functions like deriv1, etc should be left alone.

#include "mbed.h"
#include "qrsdet2-inl.h"
#include "qrsfilt-inl.h"

DigitalOut peak(LED1);
DigitalOut time_out(LED4);
DigitalOut time_out1(p18);
PwmOut bridge_out(LED2);

AnalogIn ecg_in(p20);
float float_val;
int int_val;
int delay; // return of QRSDet
int main() {
  time_out = 1;
    //qrsdet::QRSDet(0, 1);
    qrsdet::deriv1(0, 1);
    peak = 1;
    while(1) {
        float_val = ecg_in.read();
        int_val = float_val*128;
        delay = qrsdet::QRSDet(int_val, 0);
        if ( delay > 0) {
            peak = !peak;
        }
        wait_us(8000); // 125Hz
        bridge_out = float_val;
        time_out = !time_out;
        time_out1 = !time_out1;
    }
}
