#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ColumnNumber){
    Clear(LCD_COLOR_BLACK);
    SetFont(&Font24);
    SetBackColor(LCD_COLOR_RED);
    Column = ColumnNumber;
    for(unsigned char ucIndex = 0;  ucIndex < 4; ucIndex++){
        SetTextColor(LCD_COLOR_GREEN);
        DrawRect((80*ColumnNumber),ucIndex*80,80,80);
      }
    
    }

void LedLcd::On(unsigned char LedPos){
     
    for(unsigned char ucIndex = 0;  ucIndex < 4; ucIndex++){
            
        if (LedPos == ucIndex){
             SetTextColor(LCD_COLOR_GREEN);
        }   
        else{
             SetTextColor(LCD_COLOR_BLUE);
        }
            
        FillRect(1 + (80*Column),(ucIndex*80)+1,78,78);
        SetTextColor(LCD_COLOR_WHITE);
        char data[2] = {ucIndex + 48, 0};
        DisplayStringAt((80*Column),ucIndex*80, (uint8_t *) data, LEFT_MODE);
        }
    
}