#include "mbed.h"
 
Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10);
CAN can2(p30, p29);
char counter = 0;
 
void send() {
    if(can1.write(CANMessage(1337, &counter, 1))) {
        counter++;
        printf("Message sent: %d\r\n", counter);
    }
    
    printf("CAN1 rderror: %d, tderror: %d\r\n", can1.rderror(), can1.tderror() );
    printf("CAN2 rderror: %d, tderror: %d\r\n", can2.rderror(), can2.tderror() );
    
    led1 = !led1;
}
 
int main() {
    ticker.attach(&send, 1);
    CANMessage msg;
    while(1) {
        if(can2.read(msg)) {
            printf("Message received: %d\r\n", msg.data[0]);
            led2 = !led2;
        } 
        wait(0.2);
    }
}