#ifndef CPP_TO_PIGPIO_DIGITALOUT_HEADER
#define CPP_TO_PIGPIO_DIGITALOUT_HEADER
namespace CPPToPigpio{
    
    /** The DigitalOut interface is used to configure and control a digital output pin.
     */
    class DigitalOut : public CPPToPigpio{
        private:
            short _pinNumber;
            long long _lastWriteValue;
            friend class BusOut;
        public:

            /** Create a DigitalOut connected to the specified pin
             *
             *  @param pin DigitalOut pin to connect to
             */
            DigitalOut(PinName pin); //Construct Digital Output without specifying level

            /** Create a DigitalOut connected to the specified pin
             *
             *  @param pin DigitalOut pin to connect to
             *  @param value the initial pin value
             */
            DigitalOut(PinName pin, int value); //Specify initial level for the pin

            /** Create a DigitalOut connected to the specified pin
             *
             *  @param pin DigitalOut pin to connect to
             */
            DigitalOut(int pin); //Used for int args

            /** Create a DigitalOut connected to the specified pin
             *
             *  @param pin DigitalOut pin to connect to
             *  @param value the initial pin value
             */
            DigitalOut(int pin, int value);

            /** Set the output, specified as 0 or 1 (int)
             *
             *  @param value An integer specifying the pin output value,
             *      0 for logical 0, 1 (or any other non-zero value) for logical 1
             */
            void write(int value); //Set the value of the output

             /** Return the output setting, represented as 0 or 1 (int)
             *
             *  @returns
             *    an integer representing the output setting of the pin,
             *    0 for logical 0, 1 for logical 1
             */
            int read(); //return the output setting

            /** A shorthand for read()
             * \sa DigitalOut::read()
             */
            operator int();

            /** A shorthand for write()
             * \sa DigitalOut::write()
             */
            DigitalOut & operator=(int);

            /** A shorthand for write()
             * \sa DigitalOut::write()
             */
            DigitalOut & operator=(DigitalOut &rhs);

            /** Deconstructor
             */
            ~DigitalOut();
    };
}
#endif
