namespace CPPToPigpio{
    //@TODO: Confirm that PinName is convertible to int
    DigitalIn::DigitalIn(PinName pin): _pinNumber(pin)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetMode(pin, PI_INPUT); //mode for gpio refers to input or output
        DigitalIn::mode(PullNone); 
    }

    DigitalIn::DigitalIn(PinName pin, PinMode pMode): _pinNumber(pin)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetMode(pin, PI_INPUT);
        DigitalIn::mode(pMode);
    }

    DigitalIn::DigitalIn(int pin): DigitalIn::DigitalIn(static_cast<PinName> (pin))
    {
        //Doesn't need _handlePigpioInitialisationIfNeeded() since calls other constructor	
    }

    DigitalIn::DigitalIn(int pin, PinMode pMode): DigitalIn::DigitalIn(static_cast<PinName> (pin), pMode)
    {
        //Doesn't need _handlePigpioInitialisationIfNeeded() since calls other constructor	
    }

    int DigitalIn::read()
    {
        return gpioRead(_pinNumber);
    }

    DigitalIn::operator int()
    {
        return DigitalIn::read();
    }
    
    void DigitalIn::mode(PinMode pMode){
        switch(pMode){
            case PullUp:
                gpioSetPullUpDown(_pinNumber, PI_PUD_UP);
                break;
            case PullDown:
                gpioSetPullUpDown(_pinNumber, PI_PUD_DOWN); 
                break;
            case PullNone:
                gpioSetPullUpDown(_pinNumber, PI_PUD_OFF); 
                break;
        }
    }

    bool DigitalIn::operator==(int in)
    {
        return _pinNumber == in;
    }

    bool DigitalIn::operator==(DigitalIn &other)
    {
        return _pinNumber == other._pinNumber;
    }

    DigitalIn::~DigitalIn()
    {
        CPPToPigpio::_handlePigpioTermination();
    }

}

