#ifndef _CPP_TO_PIGPIO_MASTER
#define _CPP_TO_PIGPIO_MASTER
#include <stdlib.h>
#include <pigpio.h> // include GPIO library
#include <signal.h> // needed to clean up CTL C abort
#include <sys/types.h>
#include <unistd.h>

namespace CPPToPigpio{

    uint32_t CPPToPigpio::_number_active_devices = 0; //Initialize the static var

	void CPPToPigpio::errHandler (int) //unused param
	{
		gpioTerminate(); //release GPIO locks & resources
		signal(SIGINT, SIG_DFL); //exit program
		kill(getppid(), SIGINT); //kill it off
		kill(getpid(), SIGINT);
		exit(0);
	}
	
	void  CPPToPigpio::exitHandler() 
	{
		gpioTerminate(); //release GPIO locks & resources on exit
	}

	void CPPToPigpio::_setupErrorHandlers()
	{
		signal (SIGQUIT, CPPToPigpio::errHandler);// CTL C and STOP button
		signal (SIGINT,  CPPToPigpio::errHandler); // GPIO exit & cleanup
		signal (SIGTERM, CPPToPigpio::errHandler);
		signal (SIGABRT, CPPToPigpio::errHandler);
		atexit(CPPToPigpio::exitHandler);  // exit handler cleanup 
	}

    void CPPToPigpio::_handlePigpioInitialisationIfNeeded()
    {
        if(_number_active_devices == 0){
            gpioInitialise();
            CPPToPigpio::_setupErrorHandlers();
		}
        ++_number_active_devices;
    }

    void CPPToPigpio::_handlePigpioTermination()
    {
        --_number_active_devices;
        if(_number_active_devices == 0)
            gpioTerminate();

    }

}
#endif
