
namespace CPPToPigpio{
        
    //default value of NC is set in the header, need to check each pin input to make sure connected
    BusIn::BusIn (PinName p0, PinName p1, PinName p2, PinName p3, PinName p4, PinName p5, PinName p6, PinName p7, PinName p8, PinName p9, PinName p10, PinName p11, PinName p12, PinName p13, PinName p14, PinName p15)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        std::vector<PinName> pinNamesInBus;
        pinNamesInBus.emplace_back(p0);
        if(p1 != NC)
            pinNamesInBus.emplace_back(p1);
        if(p2 != NC)
            pinNamesInBus.emplace_back(p2);
        if(p3 != NC)
            pinNamesInBus.emplace_back(p3);
        if(p4 != NC)
            pinNamesInBus.emplace_back(p4);
        if(p5 != NC)
            pinNamesInBus.emplace_back(p5);
        if(p6 != NC)
            pinNamesInBus.emplace_back(p6);
        if(p7 != NC)
            pinNamesInBus.emplace_back(p7);
        if(p8 != NC)
            pinNamesInBus.emplace_back(p8);
        if(p9 != NC)
            pinNamesInBus.emplace_back(p9);
        if(p10 != NC)
            pinNamesInBus.emplace_back(p10);
        if(p11 != NC)
            pinNamesInBus.emplace_back(p11);
        if(p12 != NC)
            pinNamesInBus.emplace_back(p12);
        if(p13 != NC)
            pinNamesInBus.emplace_back(p13);
        if(p14 != NC)
            pinNamesInBus.emplace_back(p14);
        if(p15 != NC)
            pinNamesInBus.emplace_back(p15);
            
        for(size_t i=0;i<pinNamesInBus.size();++i)
        {
           _digitalIns.emplace_back(new DigitalIn(pinNamesInBus[i]));
        }

    }
    //Default val of -1 for each pin set in header
    BusIn::BusIn (int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8, int p9, int p10, int p11, int p12, int p13, int p14, int p15)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        std::vector<int> pinNamesInBus;
        pinNamesInBus.emplace_back(p0);
        if(p1 != -1)
            pinNamesInBus.emplace_back(p1);
        if(p2 != -1)
            pinNamesInBus.emplace_back(p2);
        if(p3 != -1)
            pinNamesInBus.emplace_back(p3);
        if(p4 != -1)
            pinNamesInBus.emplace_back(p4);
        if(p5 != -1)
            pinNamesInBus.emplace_back(p5);
        if(p6 != -1)
            pinNamesInBus.emplace_back(p6);
        if(p7 != -1)
            pinNamesInBus.emplace_back(p7);
        if(p8 != -1)
            pinNamesInBus.emplace_back(p8);
        if(p9 != -1)
            pinNamesInBus.emplace_back(p9);
        if(p10 != -1)
            pinNamesInBus.emplace_back(p10);
        if(p11 != -1)
            pinNamesInBus.emplace_back(p11);
        if(p12 != -1)
            pinNamesInBus.emplace_back(p12);
        if(p13 != -1)
            pinNamesInBus.emplace_back(p13);
        if(p14 != -1)
            pinNamesInBus.emplace_back(p14);
        if(p15 != -1)
            pinNamesInBus.emplace_back(p15);
            
        for(size_t i=0;i<pinNamesInBus.size();++i)
        {
           _digitalIns.emplace_back(new DigitalIn(pinNamesInBus[i]));
        }


    }
   
    //Different from MBED API, has a leading busSize argument
    BusIn::BusIn(int busSize, PinName pinNames[16])
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        //ex. input {p15 p16} pushes back 15, then back 16 to get {15 16} stored in _digitalIns
        for(int i=0;i<busSize;++i)
        {
            _digitalIns.emplace_back(new DigitalIn(pinNames[i]));
        }
    }

    //Different from MBED API, has a leading busSize argument
    BusIn::BusIn(int busSize, int pinNames[16])
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        for(int i=0;i<busSize;++i)
        {
            _digitalIns.emplace_back(new DigitalIn(pinNames[i]));
        }

    }

    //_digitalIns[0] is the MSB. Might be bad to use read() if we wanted bus of >31 bits, but restricted size to 16 for now and int is the value from MBED API.
    int BusIn::read()
    {
        int outVal = 0;
        int numBitsToShift = _digitalIns.size()-1; //Need to shift 0th bit by .size()-1 bits, etc 
        for(size_t i=0;i<_digitalIns.size();++i)
        {
            outVal = outVal | ( _digitalIns[i]->read() << numBitsToShift);
            --numBitsToShift;
        }
        
        return outVal;
    }

    void BusIn::mode(PinMode pMode)
    {
        for(size_t i=0;i<_digitalIns.size();++i)
        {
            
            switch(pMode){
                case PullUp:
                    gpioSetPullUpDown(_digitalIns[i]->_pinNumber, PI_PUD_UP);
                    break;
                case PullDown:
                    gpioSetPullUpDown(_digitalIns[i]->_pinNumber, PI_PUD_DOWN); 
                    break;
                case PullNone:
                    gpioSetPullUpDown(_digitalIns[i]->_pinNumber, PI_PUD_OFF); 
                    break;
            }
        }

    }

    BusIn::operator int()
    {
        return BusIn::read();
    }

    DigitalIn & BusIn::operator[](int index)
    {
        return *(_digitalIns[index]);
    }

    //If only digital pin is p0, would return ...000001. Is that right? Feels weird to have a 0-->0001
    //i.e. output is 0-indexed representation of which pins are on
    long long BusIn::mask()
    {
        long long output = 0;
        for(size_t i=0; i<_digitalIns.size(); ++i)
        {
            //Convert pin# to value, then add to mask by shifting a 1 into that position
           output = output | (static_cast<long long>(1) << static_cast<int>(_digitalIns[i]->_pinNumber));
        }
        return output;
    }


    BusIn::~BusIn()
    {
        CPPToPigpio::_handlePigpioTermination(); 
        while(!_digitalIns.empty())
        {
            delete _digitalIns.back();
            _digitalIns.pop_back();
        }
    }
}


