#ifndef CPP_TO_PIGPIO_PWMOUT_HEADER
#define CPP_TO_PIGPIO_PWMOUT_HEADER
namespace CPPToPigpio{

    /** The PwmOut interface is used to control the frequency and mark-space ratio of a digital pulse train.
     */
    class PwmOut : public CPPToPigpio{
        private:        
            PinName _pin;
            float _pwmValue; //Is a percentage that duty cycle is high (0-1)
            
        public:

            /** Create a PwmOut connected to the specified pin
             *
             *  @param pin PwmOut pin to connect to
             */
            PwmOut(PinName pin);
            
            /** Create a PwmOut connected to the specified pin
             *
             *  @param pin PwmOut pin to connect to
             *  @param value A floating-point value representing the output duty-cycle,
             *    specified as a percentage. The value should lie between
             *    0.0f (representing on 0%) and 1.0f (representing on 100%).
             *    Values outside this range will be saturated to 0.0f or 1.0f.
             */
            PwmOut(PinName pin, float val); //actually doesn't exist in standard mbed, but makes it easier

            /** Create a PwmOut connected to the specified pin
             *
             *  @param pin PwmOut pin to connect to
             */
            PwmOut(int pin);
            
            /** Create a PwmOut connected to the specified pin
             *
             *  @param pin PwmOut pin to connect to
             *  @param value A floating-point value representing the output duty-cycle,
             *    specified as a percentage. The value should lie between
             *    0.0f (representing on 0%) and 1.0f (representing on 100%).
             *    Values outside this range will be saturated to 0.0f or 1.0f.
             */
            PwmOut(int pin, float val); 
            
            /** Set the ouput duty-cycle, specified as a percentage (float)
             *
             *  @param value A floating-point value representing the output duty-cycle,
             *    specified as a percentage. The value should lie between
             *    0.0f (representing on 0%) and 1.0f (representing on 100%).
             *    Values outside this range will be saturated to 0.0f or 1.0f.
             */
            void write(float val);

            /** Return the current output duty-cycle setting, measured as a percentage (float)
             *
             *  @returns
             *    A floating-point value representing the current duty-cycle being output on the pin,
             *    measured as a percentage. The returned value will lie between
             *    0.0f (representing on 0%) and 1.0f (representing on 100%).
             *
             */
            float read(); //Returns current output duty cycle 

            /** Set the PWM period, specified in seconds (float), keeping the duty cycle the same.
             *
             *  @param seconds Change the period of a PWM signal in seconds (float) without modifying the duty cycle
             * 
             */
            float period(float seconds); //set PWM period, returns a float matching period that the device was actually set to

            /** Set the PWM period, specified in miliseconds (int), keeping the duty cycle the same.
             *
             *  @param miliseconds Change the period of a PWM signal in miliseconds (int) without modifying the duty cycle
             * 
             */
            float period_ms(int ms);
            
            /** Set the PWM period, specified in microseconds (int), keeping the duty cycle the same.
             *
             *  @param microseconds Change the period of a PWM signal in microseconds (int) without modifying the duty cycle
             * 
             */
            float period_us(int us);

            /** A operator shorthand for write()
             *  \sa PwmOut::write()
             */
            PwmOut & operator=(float val);

            /** A operator shorthand for write()
             *  \sa PwmOut::write()
             */
            PwmOut & operator=(PwmOut &);

            /** An operator shorthand for read()
             * \sa PwmOut::read()
             */
            operator float();
          
            /** Deconstructor
             */
            ~PwmOut();
    };

}
#endif
