#include <math.h> //For round
#define NUMBER_PWM_STEPS 5000  //5000 steps between 0 and 1.
namespace CPPToPigpio{
    PwmOut::PwmOut(PinName pin) : _pin(pin), _pwmValue(0.0f) 
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        //pigpio pwm is based on number of possible steps between fully off and on. Have to convert from %-time on to this step amount
        gpioSetPWMrange(static_cast<int>(pin), NUMBER_PWM_STEPS); 
        PwmOut::write(_pwmValue);
    }

    PwmOut::PwmOut(PinName pin, float val) : _pin(pin), _pwmValue(val) 
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetPWMrange(static_cast<int>(pin), NUMBER_PWM_STEPS); 
        PwmOut::write(_pwmValue);
    }

    PwmOut::PwmOut(int pin) : _pin(static_cast<PinName>(pin)), _pwmValue(0.0f) 
    {
        //pigpio pwm is based on number of possible steps between fully off and on. Have to convert from %-time on to this step amount
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetPWMrange(pin, NUMBER_PWM_STEPS); 
        PwmOut::write(_pwmValue);
    }

    PwmOut::PwmOut(int pin, float val) : _pin(static_cast<PinName>(pin)), _pwmValue(val) 
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetPWMrange(pin, NUMBER_PWM_STEPS); 
        PwmOut::write(_pwmValue);
    }


    void PwmOut::write(float val)
    {
        unsigned int dutyCycle = round(val*((float) NUMBER_PWM_STEPS));
        gpioPWM(static_cast<int>(_pin), dutyCycle); 
    }

    float PwmOut::read()
    {
        //Recalculate the pwm duty cycle, since it's possible to get a different result than what was set by the user (if the input period*NUMBER_PWM_STEPS is not an int)
        unsigned numSteps = gpioGetPWMdutycycle(static_cast<int>(_pin));
        return (static_cast<float>(numSteps)/static_cast<float>(NUMBER_PWM_STEPS));
    }

    float PwmOut::period(float seconds)
    {
        //Depends on Pi PWM sample rate, default is 5 and for now not changing from that
        unsigned int freq = static_cast<int>(1.0f/seconds);
        return 1.0f/(static_cast<float>(gpioSetPWMfrequency(_pin, freq))); //Likely WILL NOT match input
    }

    float PwmOut::period_ms(int ms)
    {
        float seconds = static_cast<float>(ms)/1000.0f;
        unsigned int freq = static_cast<int>(1.0f/seconds);
        return 1.0f/(static_cast<float>(gpioSetPWMfrequency(_pin, freq)));
    }

    float PwmOut::period_us(int us)
    {
        float seconds = static_cast<float>(us)/1000000.0f;
        unsigned int freq = static_cast<int>(1.0f/seconds);
        return 1.0f/(static_cast<float>(gpioSetPWMfrequency(_pin, freq)));
    }

    PwmOut & PwmOut::operator=(float val)
    {
        PwmOut::write(val);
        return *this;
    }

    PwmOut & PwmOut::operator=(PwmOut & rhs)
    {
        PwmOut::write(rhs.read());
        return *this;
    }

    PwmOut::operator float()
    {
        return PwmOut::read();
    }

    PwmOut::~PwmOut()
    {
        CPPToPigpio::_handlePigpioTermination(); 
    }
}

