//I2C.cc
#include <stdio.h>
namespace CPPToPigpio {
	I2C::I2C(PinName sdapin, PinName sclpin) : _pinsda(sdapin), _pinscl(sclpin)
	{
		//note: cannot mix and match buses
		CPPToPigpio::_handlePigpioInitialisationIfNeeded();
		if (_pinsda==p0 && _pinscl==p1) {
			_I2CBus = 0;
		}
		else if (_pinsda==p2 && _pinscl==p3){ 
			_I2CBus = 1;
		}
		else{
			perror("I2C0: sda-> p0, scl-> p1\nI2C1: sda-> p2, scl-> p3\n");
			_pinsda=_pinscl=NC;
			_I2CBus=-1;
		}
		gpioSetMode(static_cast<int>(_pinsda), PI_ALT0);
		gpioSetMode(static_cast<int>(_pinscl), PI_ALT0);
		_repeated = false;
		_bbstarted =false;
		_baud = 50000;
		
	}
	I2C::I2C(int sdapin, int sclpin) : I2C(static_cast<PinName>(sdapin), static_cast<PinName>(sclpin))
	{
		
	}
	I2C::~I2C(){
		CPPToPigpio::_handlePigpioTermination();
	}
	void I2C::frequency( int hz){
		_baud=hz;
	} 
	
	int I2C::read(unsigned address, char* buf, int length, bool repeated=false){
		_repeated = repeated;
		_handle = i2cOpen(_I2CBus, address, 0); //returns >=0
		int ret=i2cReadDevice(_handle, buf, length);
		i2cClose(_handle);
		if (_repeated) i2cSwitchCombined(1); 
		else i2cSwitchCombined(0);//turn off repeated start
		return !ret;
		
	}
	int I2C::read(__attribute__((unused)) int ack){
		int ret;
		if (_bbstarted){
			char cmdBuf[2] = { Read, 0x02}; //no stop
			char out[2];
			bbI2CZip(_pinsda, cmdBuf, 2, out, 2);
			ret=out[0];
			
		}
		else{
			_handle = i2cOpen(_I2CBus, 0, 0);
			ret= i2cReadByte(_handle); 
			i2cClose(_handle);
	}
		return ret;
	}
	int I2C::write(unsigned address, char* buf, int length, bool repeated = false){
		_repeated=repeated;
		int ret; 
		char tmp[length+1]={0};
		unsigned reg;
		if (_repeated) i2cSwitchCombined(1); //write->read to same addr => repeated start
		else i2cSwitchCombined(0);
		_handle = i2cOpen(_I2CBus, address, 0);
		if (length>1){
			reg = buf[0];
			for (int i=0; i<length; i++){
				tmp[i+1]=buf[i];
			}
			ret = i2cWriteBlockData(_handle, reg, tmp, length);
		}
		else{
			ret = i2cWriteDevice(_handle, buf, length);
		}
		i2cClose(_handle);
		return !ret;
	}
	int I2C::write(int data){
		int ret;
		if (_bbstarted ){
			char tmp = (unsigned)data;
			char cmdBuf[3] = { Write,0x01, tmp}; //no stop
			char out[1];
			ret=bbI2CZip(_pinsda, cmdBuf, 3, out, 1);
		}
		
		else{
			_handle = i2cOpen(_I2CBus, 0, 0);
			ret = i2cWriteByte(_handle, data);
			i2cClose(_handle);
		}
		if (ret>=0) return 1;
		else return ret;
		
	}
	
	void I2C::start(void){
		if (!_bbstarted){
			bbI2COpen(_pinsda, _pinscl, _baud);
		}
		char cmdBuf[1] = {Start};
		char out[1];
		bbI2CZip(_pinsda, cmdBuf, 1, out, 1);
		_bbstarted = true;
		
	}
	void I2C::stop(void){
		if (_bbstarted) {
			char cmdBuf[1] = {Stop};
			char out[1];
			bbI2CZip(_pinsda, cmdBuf, 1, out, 1);
			bbI2CClose(_pinsda);
			_bbstarted = false;
			}
		
	}
	
	
	int I2C::bang(char* inBuf, unsigned inLen, char* outBuf, unsigned outLen, bool cont=false){
		if(!_bbstarted) {
			bbI2COpen(_pinsda, _pinscl, _baud);
			_bbstarted=true;}
		int ret=bbI2CZip(_pinsda, inBuf, inLen, outBuf, outLen);
		if (!cont) {
			bbI2CClose(_pinsda);
			_bbstarted=false;
		}
		if (ret>=0) return 1;
		else return ret;
	
		
	}
	
	
}

