namespace CPPToPigpio{
    DigitalOut::DigitalOut(PinName pin) : _pinNumber(pin)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetMode(static_cast<int>(pin), PI_OUTPUT);
    }
    DigitalOut::DigitalOut(PinName pin, int value) : _pinNumber(pin)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        gpioSetMode(static_cast<int>(pin), PI_OUTPUT);
        DigitalOut::write(value);
    }
    
    DigitalOut::DigitalOut(int pin) : DigitalOut(static_cast<PinName> (pin))
    {
        //Doesn't need _handlePigpioInitialisationIfNeeded() since calls other constructor	
    }

    DigitalOut::DigitalOut(int pin, int value) : DigitalOut(static_cast<PinName> (pin), value)
    {
	    //Doesn't need _handlePigpioInitialisationIfNeeded() since calls other constructor	
    }
    
    void DigitalOut::write(int value)
    {   
        //Should we perror here if value isn't 0 or 1? MBED should allow value == 2, but pigpio might not
        if(value == 0) gpioWrite(static_cast<int>(_pinNumber), 0);
        else gpioWrite(static_cast<int>(_pinNumber), 1);    
        _lastWriteValue = value;
    }

    int DigitalOut::read()
    {
        return _lastWriteValue;
    }
    
    DigitalOut::operator int()
    {
        return DigitalOut::read();
    }
    
    DigitalOut & DigitalOut::operator=(int value)
    {
        DigitalOut::write(value);
        return *this;
    }
    
    DigitalOut & DigitalOut::operator=(DigitalOut &rhs)
    {
        DigitalOut::write(rhs.read());
        return *this;
    }

    DigitalOut::~DigitalOut()
    {
        CPPToPigpio::_handlePigpioTermination(); 
    }

}
