#ifndef CPP_TO_PIGPIO_DIGITALIN_HEADER
#define CPP_TO_PIGPIO_DIGITALIN_HEADER
namespace CPPToPigpio{
    /** The DigitalIn interface is used to read the value of a digital input pin.
     */
    class DigitalIn : public CPPToPigpio{
        private:
            short _pinNumber; //Internally track which pin this input is on
            friend class BusIn;
        public:
            /** Create a DigitalIn connected to the specified pin
             *
             *  @param pin DigitalIn pin to connect to
             */
            DigitalIn(PinName pin); //Construct a Digital Input without a PullUp or PullDown resistor

            /** Create a DigitalIn connected to the specified pin
             *
             *  @param pin DigitalIn pin to connect to
             *  @param mode the initial mode of the pin
             */
            DigitalIn(PinName pin, PinMode mode); //mode is PullUp, PullDown, or PullNone

            /** Create a DigitalIn connected to the specified pin
             *
             *  @param pin DigitalIn pin to connect to
             */
            DigitalIn(int pin); //handles int args as a static cast

            /** Create a DigitalIn connected to the specified pin
             *
             *  @param pin DigitalIn pin to connect to
             *  @param mode the initial mode of the pin
             */
            DigitalIn(int pin, PinMode mode); 
        
            /** Read the input, represented as 0 or 1 (int)
             *
             *  @returns
             *    An integer representing the state of the input pin,
             *    0 for logical 0, 1 for logical 1
             */
            int read(); //longform way to get the value on the pin

            /** An operator shorthand for read()
             * \sa DigitalIn::read()
             */
            operator int(); //conversion operator

            /** Set the input pin mode
             *
             *  @param pull PullUp, PullDown, PullNone, OpenDrain
             */
            void mode(PinMode mode); //Sets the pin to be PullUp, PullDown, or PullNone

            /** Check equality of pin to other DigitalIn pin
             */
            bool operator==(int);
            
            /** Check equality of pin to other DigitalIn pin
             */
            bool operator==(DigitalIn &);

            /** Deconstructor
             */
            ~DigitalIn();
    };   
}
#endif
