#ifndef __CPP_TO_PIGPIO_
#define __CPP_TO_PIGPIO_
#include <stdint.h>
#include <pigpio.h> // include GPIO library

enum PinName{NC=-1, p0=0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24, p25, p26, p27, p28, p29, p30, p31, p32, p33, p34, p35, p36, p37, p38, p39, p40, p41, p42, p43, p44, p45, p46, p47, p48, p49, p50, p51, p52, p53};
enum PinMode{PullUp=PI_PUD_UP, PullDown=PI_PUD_DOWN, PullNone=PI_PUD_OFF};


namespace CPPToPigpio{
    
    class CPPToPigpio{
        private:
            static uint32_t _number_active_devices; //Need to track number of devices so that can call gpioInitialise() if making first device
        protected:
            void _handlePigpioInitialisationIfNeeded();             
            void _handlePigpioTermination();
            void _setupErrorHandlers();
            static void errHandler(int);
            static void exitHandler();

    };

}
#include "DigitalIn.h"
#include "DigitalOut.h"
#include "BusIn.h"
#include "BusOut.h"
#include "PwmOut.h"
#include "I2C.h"

#endif
