#ifndef CPP_TO_PIGPIO_BUSOUT_HEADER
#define CPP_TO_PIGPIO_BUSOUT_HEADER

#include <vector>
namespace CPPToPigpio{
    /** 
     * A BusOut interface is used to create several DigitalOut pins that can be written to using only one value.
     */

    class BusOut : public CPPToPigpio{
        private:
            std::vector<DigitalOut *> _digitalOuts;
            long long _lastWrittenValue; //Track what we last wrote to outputs for read() 
        public:
            
            /** Create an BusOut, connected to the specified pins
             * 
             *  @param p0 DigitalOut pin to connect to bus bit
             *  @param p1 DigitalOut pin to connect to bus bit
             *  @param p2 DigitalOut pin to connect to bus bit
             *  @param p3 DigitalOut pin to connect to bus bit
             *  @param p4 DigitalOut pin to connect to bus bit
             *  @param p5 DigitalOut pin to connect to bus bit
             *  @param p6 DigitalOut pin to connect to bus bit
             *  @param p7 DigitalOut pin to connect to bus bit
             *  @param p8 DigitalOut pin to connect to bus bit
             *  @param p9 DigitalOut pin to connect to bus bit
             *  @param p10 DigitalOut pin to connect to bus bit
             *  @param p11 DigitalOut pin to connect to bus bit
             *  @param p12 DigitalOut pin to connect to bus bit
             *  @param p13 DigitalOut pin to connect to bus bit
             *  @param p14 DigitalOut pin to connect to bus bit
             *  @param p15 DigitalOut pin to connect to bus bit
             */
            BusOut (PinName p0, PinName p1=NC, PinName p2=NC, PinName p3=NC, PinName p4=NC, PinName p5=NC, PinName p6=NC, PinName p7=NC, PinName p8=NC, PinName p9=NC, PinName p10=NC, PinName p11=NC, PinName p12=NC, PinName p13=NC, PinName p14=NC, PinName p15=NC);

            /** Create an BusOut, connected to the specified pins
             * 
             *  @param p0 DigitalOut pin to connect to bus bit
             *  @param p1 DigitalOut pin to connect to bus bit
             *  @param p2 DigitalOut pin to connect to bus bit
             *  @param p3 DigitalOut pin to connect to bus bit
             *  @param p4 DigitalOut pin to connect to bus bit
             *  @param p5 DigitalOut pin to connect to bus bit
             *  @param p6 DigitalOut pin to connect to bus bit
             *  @param p7 DigitalOut pin to connect to bus bit
             *  @param p8 DigitalOut pin to connect to bus bit
             *  @param p9 DigitalOut pin to connect to bus bit
             *  @param p10 DigitalOut pin to connect to bus bit
             *  @param p11 DigitalOut pin to connect to bus bit
             *  @param p12 DigitalOut pin to connect to bus bit
             *  @param p13 DigitalOut pin to connect to bus bit
             *  @param p14 DigitalOut pin to connect to bus bit
             *  @param p15 DigitalOut pin to connect to bus bit
             */
            BusOut (int p0, int p1=-1, int p2=-1, int p3=-1, int p4=-1, int p5=-1, int p6=-1, int p7=-1, int p8=-1, int p9=-1, int p10=-1, int p11=-1, int p12=-1, int p13=-1, int p14=-1, int p15=-1);
            
            /** Creates a BusOut, connected to the specific pins.
             * 
             * @param number of pins specified
             * @param array of pins to connect to bus
             */

            //This is different from standard MBED API. Since the literal 0 is a valid pinName, need busSize to be passed in to tell which pins matter.
            BusOut (int busSize, PinName pinNames[16]);

            /** Creates a BusOut, connected to the specific pins.
             * 
             * @param number of pins specified
             * @param array of pins to connect to bus
             */

            //This is different from standard MBED API. Since the literal 0 is a valid pinName, need busSize to be passed in to tell which pins matter.
            BusOut (int busSize, int pinNames[16]);

             /** Write the value to the output bus
             *
             *  @param value An integer specifying a bit to write for every corresponding DigitalOut pin
             */
            void write(int value);
      
            /** Read the value currently output on the bus
             *
             *  @returns An integer with each bit corresponding to associated DigitalOut pin setting
             */
            int read();

            /** A shorthand for read()
             * \sa BusOut::read()
             */
            operator int();

            /** Access to particular bit in random-iterator fashion
             * @param index  Bit Position
             */
            DigitalOut & operator[](int index);
                
            /** A shorthand for write()
             * \sa BusOut::write()
             */
            BusOut & operator=(int v); //Short for write

            /** Binary mask of bus pins connected to actual pins (not NC pins)
             *  If bus pin is in NC state make corresponding bit will be cleared (set to 0), else bit will be set to 1
             *
             *  @returns Binary mask of connected pins
             */
            //Returns mask of connected pins, double check that this matches what it should do. Note that since 0 is valid, mask of BusIn(0) will return 0b000..1 and mask(BusIn(1)) returns 0b000..10
            long long mask(); 

            /** Desconstructor for object
             */
            ~BusOut();

    };


}

#endif
