namespace CPPToPigpio{
        
    //default value of NC is set in the header, need to check each pin input to make sure connected
    BusOut::BusOut (PinName p0, PinName p1, PinName p2, PinName p3, PinName p4, PinName p5, PinName p6, PinName p7, PinName p8, PinName p9, PinName p10, PinName p11, PinName p12, PinName p13, PinName p14, PinName p15)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        std::vector<PinName> pinNamesOutBus;
        pinNamesOutBus.emplace_back(p0);
        if(p1 != NC)
            pinNamesOutBus.emplace_back(p1);
        if(p2 != NC)
            pinNamesOutBus.emplace_back(p2);
        if(p3 != NC)
            pinNamesOutBus.emplace_back(p3);
        if(p4 != NC)
            pinNamesOutBus.emplace_back(p4);
        if(p5 != NC)
            pinNamesOutBus.emplace_back(p5);
        if(p6 != NC)
            pinNamesOutBus.emplace_back(p6);
        if(p7 != NC)
            pinNamesOutBus.emplace_back(p7);
        if(p8 != NC)
            pinNamesOutBus.emplace_back(p8);
        if(p9 != NC)
            pinNamesOutBus.emplace_back(p9);
        if(p10 != NC)
            pinNamesOutBus.emplace_back(p10);
        if(p11 != NC)
            pinNamesOutBus.emplace_back(p11);
        if(p12 != NC)
            pinNamesOutBus.emplace_back(p12);
        if(p13 != NC)
            pinNamesOutBus.emplace_back(p13);
        if(p14 != NC)
            pinNamesOutBus.emplace_back(p14);
        if(p15 != NC)
            pinNamesOutBus.emplace_back(p15);
            
        for(size_t i=0;i<pinNamesOutBus.size();++i)
        {
           _digitalOuts.emplace_back(new DigitalOut(pinNamesOutBus[i]));
        }

    }
    //Default val of -1 for each pin set in header
    BusOut::BusOut (int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8, int p9, int p10, int p11, int p12, int p13, int p14, int p15)
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        std::vector<int> pinNamesOutBus;
        pinNamesOutBus.emplace_back(p0);
        if(p1 != -1)
            pinNamesOutBus.emplace_back(p1);
        if(p2 != -1)
            pinNamesOutBus.emplace_back(p2);
        if(p3 != -1)
            pinNamesOutBus.emplace_back(p3);
        if(p4 != -1)
            pinNamesOutBus.emplace_back(p4);
        if(p5 != -1)
            pinNamesOutBus.emplace_back(p5);
        if(p6 != -1)
            pinNamesOutBus.emplace_back(p6);
        if(p7 != -1)
            pinNamesOutBus.emplace_back(p7);
        if(p8 != -1)
            pinNamesOutBus.emplace_back(p8);
        if(p9 != -1)
            pinNamesOutBus.emplace_back(p9);
        if(p10 != -1)
            pinNamesOutBus.emplace_back(p10);
        if(p11 != -1)
            pinNamesOutBus.emplace_back(p11);
        if(p12 != -1)
            pinNamesOutBus.emplace_back(p12);
        if(p13 != -1)
            pinNamesOutBus.emplace_back(p13);
        if(p14 != -1)
            pinNamesOutBus.emplace_back(p14);
        if(p15 != -1)
            pinNamesOutBus.emplace_back(p15);
            
        for(size_t i=0;i<pinNamesOutBus.size();++i)
        {
           _digitalOuts.emplace_back(new DigitalOut(pinNamesOutBus[i]));
        }


    }
   
    //Different from MBED API, has a leading busSize argument
    BusOut::BusOut(int busSize, PinName pinNames[16])
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        //ex. input {p15 p16} pushes back 15, then back 16 to get {15 16} stored in _digitalOuts
        for(int i=0;i<busSize;++i)
        {
            _digitalOuts.emplace_back(new DigitalOut(pinNames[i]));
        }
    }

    //Different from MBED API, has a leading busSize argument
    BusOut::BusOut(int busSize, int pinNames[16])
    {
        CPPToPigpio::_handlePigpioInitialisationIfNeeded();
        for(int i=0;i<busSize;++i)
        {
            _digitalOuts.emplace_back(new DigitalOut(pinNames[i]));
        }

    }


    //_digitalIns[0] is the MSB. Might be bad to use read() if we wanted bus of >31 bits, but restricted size to 16 for now and int is the value from MBED API.
    void BusOut::write(int val)
    {
        long long currentMask = 1;
        for(uint32_t i=0;i<_digitalOuts.size();++i)
        {
            (_digitalOuts[_digitalOuts.size()-i-1])->write( (val & currentMask) != 0);
            currentMask = currentMask << 1;
        }
        _lastWrittenValue = val;
    }

    int BusOut::read()
    {
        return _lastWrittenValue;
    }

    BusOut::operator int()
    {
        return BusOut::read();
    }

    DigitalOut & BusOut::operator[](int index)
    {
        return *(_digitalOuts[index]);
    }

    BusOut & BusOut::operator=(int v)
    {
        BusOut::write(v);
        return *this;
    }

    //If only digital pin is p0, would return ...000001. Is that right? Feels weird to have a 0-->0001
    //i.e. output is 0-indexed representation of which pins are on
    long long BusOut::mask()
    {
        long long output = 0;
        for(size_t i=0; i<_digitalOuts.size(); ++i)
        {
            //Convert pin# to value, then add to mask by shifting a 1 into that position
           output = output | (static_cast<long long>(1) << static_cast<int>(_digitalOuts[i]->_pinNumber));
        }
        return output;
    }

    BusOut::~BusOut()
    {
        CPPToPigpio::_handlePigpioTermination(); 
        while(!_digitalOuts.empty())
        {
            delete _digitalOuts.back();
            _digitalOuts.pop_back();
        }
    }

}


