#ifndef CPP_TO_PIGPIO_BUSIN_HEADER
#define CPP_TO_PIGPIO_BUSIN_HEADER
#include <vector>
namespace CPPToPigpio{
    /**
     * BusIn is used to create a number of DigitalIn pins that can be read as one value. 
     */

    class BusIn : public CPPToPigpio{
        private:
            std::vector<DigitalIn *> _digitalIns;
        public:
            /**
             * Creates a BusIn, connected to the specific pins. 
             * 
             * @param p0 DigitalIn pin to connect to bus bit
             * @param p1 DigitalIn pin to connect to bus bit
             * @param p2 DigitalIn pin to connect to bus bit
             * @param p4 DigitalIn pin to connect to bus bit
             * @param p5 DigitalIn pin to connect to bus bit
             * @param p6 DigitalIn pin to connect to bus bit
             * @param p7 DigitalIn pin to connect to bus bit
             * @param p8 DigitalIn pin to connect to bus bit
             * @param p9 DigitalIn pin to connect to bus bit
             * @param p10 DigitalIn pin to connect to bus bit
             * @param p11 DigitalIn pin to connect to bus bit
             * @param p12 DigitalIn pin to connect to bus bit
             * @param p13 DigitalIn pin to connect to bus bit
             * @param p14 DigitalIn pin to connect to bus bit
             * @param p15 DigitalIn pin to connect to bus bit
             */
            BusIn (PinName p0, PinName p1=NC, PinName p2=NC, PinName p3=NC, PinName p4=NC, PinName p5=NC, PinName p6=NC, PinName p7=NC, PinName p8=NC, PinName p9=NC, PinName p10=NC, PinName p11=NC, PinName p12=NC, PinName p13=NC, PinName p14=NC, PinName p15=NC);

            /**
             * Creates a BusIn, connected to the specific pins. 
             * 
             * @param p0 DigitalIn pin to connect to bus bit
             * @param p1 DigitalIn pin to connect to bus bit
             * @param p2 DigitalIn pin to connect to bus bit
             * @param p4 DigitalIn pin to connect to bus bit
             * @param p5 DigitalIn pin to connect to bus bit
             * @param p6 DigitalIn pin to connect to bus bit
             * @param p7 DigitalIn pin to connect to bus bit
             * @param p8 DigitalIn pin to connect to bus bit
             * @param p9 DigitalIn pin to connect to bus bit
             * @param p10 DigitalIn pin to connect to bus bit
             * @param p11 DigitalIn pin to connect to bus bit
             * @param p12 DigitalIn pin to connect to bus bit
             * @param p13 DigitalIn pin to connect to bus bit
             * @param p14 DigitalIn pin to connect to bus bit
             * @param p15 DigitalIn pin to connect to bus bit
             */
            BusIn (int p0, int p1=-1, int p2=-1, int p3=-1, int p4=-1, int p5=-1, int p6=-1, int p7=-1, int p8=-1, int p9=-1, int p10=-1, int p11=-1, int p12=-1, int p13=-1, int p14=-1, int p15=-1);

            /**
             * Creates a BusIn, connected to the specific pins.
             * @param number of pins specified
             * @param array of pins to connect to bus
             */
            
            //This is different from standard MBED API. Since the literal 0 is a valid pinName, need busSize to be passed in to tell which pins matter.
            BusIn (int busSize, PinName pinNames[16]);

            /**
             * Creates a BusIn, connected to the specific pins.
             * @param number of pins specified
             * @param array of pins to connect to bus
             */

            //This is different from standard MBED API. Since the literal 0 is a valid pinName, need busSize to be passed in to tell which pins matter.
            BusIn (int busSize, int pinNames[16]);
      
            /**
             * Read value of input pins
             * 
             * @returns An integer with each bit corresponding to the value read from the associated DigitalIn pin
             */
            int read();

            /**
             * Sets the input pin mode for all pins in the bus
             * 
             * @param pull PullUp, PullDown, PullNone
             */
            void mode(PinMode pull);

            /** A shorthand for read()
             * \sa BusOut::read()
             */
            operator int();

            /** Access to particular bit in random-iterator fashion
             * 
             * @param index or position of bit
             */
            DigitalIn & operator[](int index);

            /** Binary mask of bus pins connected to actual pins (not NC pins)
             *  If bus pin is in NC state make corresponding bit will be cleared (set to 0), else bit will be set to 1
             *
             *  @returns Binary mask of connected pins
             */
            //Returns mask of connected pins, double check that this matches what it should do. Note that since 0 is valid, mask of BusIn(0) will return 0b000..1 and mask(BusIn(1)) returns 0b000..10
            long long mask(); 

            /** Desconstructor for object
             */
            ~BusIn();

    };


}
#endif
