#include <iostream>
#include <CPPToPigpio.h>
#include "MPR121.cc"
//using namespace CPPToPigpio;

CPPToPigpio::I2C myi2c(p2, p3);  
Mpr121 mpr121(&myi2c, Mpr121::ADD_VSS);
void fallInterrupt(int gpio, int level, uint32_t tick) {
    int key_code=0;
         int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    
		for (int i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
        
        if (key_code) printf("Key Pressed: %d\n", key_code-1);
        

}

int main()
{
	
    //gpioInitialise();
 
    printf("\nHello from the mbed & mpr121\n\r");
 
    unsigned char dataArray[2];
    int key;
    int count = 0;
 
    printf("Test 1: read a value: \r\n");
    dataArray[0] = mpr121.read(AFE_CFG);
    printf("Read value=%x\r\n\n",dataArray[0]);
 
    printf("Test 2: read a value: \r\n");
    dataArray[0] = mpr121.read(0x5d);
    printf("Read value=%x\r\n\n",dataArray[0]);
 
    printf("Test 3: write & read a value: \r\n");
    mpr121.read(ELE0_T);
    mpr121.write(ELE0_T,0x22);
    dataArray[0] = mpr121.read(ELE0_T);
    printf("Read value=%x\r\n\n",dataArray[0]);
 
    printf("Test 4: Write many values: \r\n");
    unsigned char data[] = {0x1,0x3,0x5,0x9,0x15,0x25,0x41};
    mpr121.writeMany(0x42,data,7);
 
    // Now read them back ..
    key = 0x42;
    count = 0;
    while (count < 7) {
        char result = mpr121.read(key);
        key++;
        count++;
        printf("Read value: '%x'=%x\n\r",key,result);
    }
 
    printf("Test 5: Read Electrodes:\r\n");
    key = ELE0_T;
    count = 0;
    while (count < 24) {
        char result = mpr121.read(key);
        printf("Read key:%x value:%x\n\r",key,result);
        key++;
        count++;
    }
    printf("--------- \r\n\n");
 
    //mpr121.setProximityMode(true);
	printf("reading...\r\n");
    printf("ELE_CFG=%x\r\n", mpr121.read(ELE_CFG));
 
    CPPToPigpio::DigitalIn intr(p17);
    intr.mode(PullUp);
	gpioSetISRFunc(p17, FALLING_EDGE, 0, fallInterrupt);
	
	
    while (1) {
        time_sleep(5);
        printf(".\r\n");
        
    }
    
    
    gpioTerminate();
}
 
 
    





