#include "mbed.h"

DigitalOut  my_led(LED1);
InterruptIn my_button(USER_BUTTON);
PwmOut      my_pwmR(PB_3);
PwmOut      my_pwmL(PB_5);

void pressed() {
    /*
    if (my_pwmRR.read() == 0.25) {
        my_pwmRR.write(0.75);
    }
    else if (my_pwmRR.read() == 0.5) {
        my_pwmRR.write(0.25);
    }    
    else {
        my_pwmRR.write(0.50);
    }
    */
}

int main()
{
    #define DIR_P 1
    #define DIR_N 0
    
    float pwm_v = 0.0;
    char direction;
    // Set PWM
    my_pwmR.period_ms(8);
    my_pwmR.write(pwm_v);
 
    my_pwmL.period_ms(5);
    my_pwmL.write(pwm_v);
    
    // Set button
    my_button.fall(&pressed);
    
    while (1) {
        my_led = !my_led;
        if ( pwm_v >= 0.9 )
        {
            direction = DIR_N;
        }
        else if ( pwm_v <= 0.1 )
        {    
            direction = DIR_P;
        }
            
        if( direction == DIR_P)
            pwm_v+=0.1;
        else 
            pwm_v-=0.1;
            
        my_pwmR.write(pwm_v);  
        my_pwmL.write(pwm_v); 
        printf("==LOOP== pwm_v : %.1f   DIR : %d \n",pwm_v,direction); 
        wait(0.1); // 500 ms
    }
}
