#include "mbed.h"
#include <PwmIn.h>
#include <stdio.h>
#include "math.h"
 
DigitalIn mybutton(USER_BUTTON);
DigitalOut trig(PA_10);     // D2
Serial pc(USBTX,USBRX);     
PwmOut servo(PB_5);         // D4
PwmIn LidarI(PB_3);         // D3
InterruptIn bouton(USER_BUTTON);

void Mesure(float *pmes){
    wait_ms(40); //Laisser le moteur arriver à sa position
    trig = 1;
    trig=0;        // Déclenchement
    wait_ms(10);  //Attendre que le signal du LIDAR soit clair pour le microcontroleur et pas parasité par le front descendant du déclenchement
    *pmes = LidarI.pulsewidth() / 10;  //Lecture du signal et enregistrement dans la variable "mes" (en µs)
    trig = 1;  //Stop de la prise de mesure
 //   pc.printf("Mesure prise : %f \n",*pmes); //Affichage de la mesure prise (mesure de la distance en cm)
}



float conversion_deg_rad (int in){
    return in*0.017453292519943f;
 }

int aireSegment (float t[],int angle,int i){
    float a=t[i],b=t[i-1],c=0.0f;
    float tmp=0.0f,ret=0.0f,s=0.0f;
    
    tmp =(a*a)+(b*b)-(2.0f*a*b*cos(conversion_deg_rad(angle)));  
    c = sqrt(tmp);    
    s = (a+b+c)/2;                              // Autre formule intéressante : s=1/4 sqrt((a+(b+c))*(c-(a-b))*(c+(a-b))*(a+(c-b)))
                                                // Cette formule est plus stable lorsque l'un des cotes est très petit
                                                // Utiliser de telmanière que a>b>c
    ret = sqrt(s*(s-a)*(s-b)*(s-c));
    
    pc.printf("aire segment : %f \n", ret);
    
    return ret;
} 

void arret(){
    sleep(); 
}
 
int main() {
    // Déclarations des variables
    int angle_degree = 1;
    float mes = 0;          //Variable qui contient les mesures 
    float *pmes = &mes;     //Pointeur qui permettra d'accéder à la variable mesure en dehors du sous programme principale "main"
    float aireTotale = 0, angle=0.01f,A = 0.8f;   // "aireTotale" permet de récupérer la valeur recherchée, on y ajoute l'aire de chaque segments à chaque calcul de ceux-ci
                                                 // "Angle" de chaque rotation du moteur entre chaque prises de mesure (en degrés d'angle !!!)
                                                 // "A" un flottant qui permet de controler le servomoteur (en millisecondes !!!) 
                                                 //         ( 1.0 fonctionnel mais ne va pas jusqu'a 0° pour le moteur 
                                                 //         0.8 ne marche pas avec les autres fonctions mais permet de positionner le moteur à son maximum)
                                                 // "angle_parcouru" indique en degré d'angle l'angle parcouru par le moteur depuis le lancement du programme
    
    int i = 0,nbMes = 1.4f/angle;            // "i" sert d'index dans le tableau dans lequel on stock les mesures 
                                            // "nbMes" correspond au nombre de mesure qui seront effectuées
    
    float tabM[nbMes];              // "tabM" Un tableau dans lequel sera enregistré les mesures effectuées
    bouton.rise(&arret);            // Pour arreter le programme en appuyant sur le bouton bleu
    
    pc.printf("\nLancement du programme...\n");
 
    trig = 1;                    // "trig" à 1 --> LIDAR attend que "trig" passe à 0 pour prendre des mesures en somme il est en "standby"
    servo.pulsewidth_us(A*1000); // On fixe le servomoteur à son angle minimum       
    Mesure(pmes);                // Lancement de la fonction qui prend une mesure et qui inscrit dans "mes" lavaleur de la mesure effectuée
    tabM[i]=mes;                 // La mesure est enregistrée dans le tableau des mesures
    i++;                         // L'index du tableau augment donc d'un
    wait(1);       
    
    for(A = 0.8f; A <= 2.2f ; A += angle){
          
          servo.pulsewidth_us(A*1000);                       // Positionnement du Moteur à sa position minimum
          Mesure(pmes);                                      // Effectue une mesure et la stocke dans la variable "mes"
          tabM[i]=mes;                                       // Stock la valeur contenu dans la varaible "mes" dans le tableau 
          i++;                                               // incrémentation de l'index du tableau des mesures
          aireTotale += aireSegment(tabM, angle_degree, i);       //Calcul de l'aire de chaque segment et de l'aire totale
          wait(0.01);
    }
                  
                                 
    servo.pulsewidth(0);                         
    i=0;                                         // Reinitialisation de i pour pouvoir le reutiliser
     while(i<nbMes){                             // Affichage des mesures
        pc.printf("M(%d):[%f]\n",i ,tabM[i]);      
        i=i++;                                      
    }
    
    pc.printf("\n Aire total : %f \n", aireTotale);     
    pc.printf("Arret du programme...");
    sleep();
}
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
