/*
    RadarDemo - Simple radar simulator, example of 2D graphics for STM32F746G-DISCO.

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"),
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "RK043FN48H.h"
#include "RadarDemo.h"

RK043FN48H display;

int main()
{
    RadarDemo demo(&display);
    demo.Initialize();

    // Set background color for non-transparent dark blue
    display.SetActiveLayer(Background);
    display.SetBackgroundColor(0xFF000032);  
    display.SetActiveLayer(Foreground);
    
    while(demo.IsRunning()) {
        
        // Render single frame
        demo.Render();
        
        // Wait a short time to see rendered frame
        wait(0.02f);
    }
}
