//
// Target.cpp - Simple simulation of radar target
// 

#include "Target.h"
#include "math.h"

Target::Target(int id, float speed, float direction)
{
    Id = id;

    _speed = speed;
    _direction = direction;

    _type = 0;
    _lastUpdateTime = 0;
}


Target::Target(int id, float x, float y, float h, float speed, float direction)
{
    _location.SetLocation(x, y, h);
    _speed = speed;
    _direction = direction;

    _type = 0;
    _lastUpdateTime = 0;
    Id = id;
}

Location Target::GetLocation()
{
    return _location;
}

void Target::SetLocation(float x, float y)
{
    _location.SetLocation(x, y, _location.GetHeight());
}

float Target::GetX()
{
    return _location.GetX();
}

float Target::GetY()
{
    return _location.GetY();
}

float Target::GetAzimuth()
{
    return _location.GetAzimuth();
}

float Target::GetDistance()
{
    return _location.GetDistance();
}

float Target::GetDirection()
{
    return _direction;
}

float Target::GetSpeed()
{
    return _speed;
}

int Target::GetType()
{
    return _type;
}

void Target::UpdateLocationForTime(uint32_t currentTime)
{
    // Calculate time period from last update
    uint32_t timePeriod = currentTime - _lastUpdateTime;
    _lastUpdateTime = currentTime;
    
    float distance = _speed * timePeriod / 3600000;
    float dx = distance * sinf(GetDirection());
    float dy = distance * cosf(GetDirection());
    SetLocation(GetX() + dx, GetY() + dy);
}

void Target::SetLocationAngular(float distance, float azimuth)
{
    _location.SetLocationAngular(distance, azimuth, _location.GetElevation());
}
