/*
    Location.h - class defines 3D location in cartesian and angular coordinations.

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"),
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#pragma once

/**
  * @brief Class defines 3D location in cartesian and angular coordinations.
  */
class Location
{
public:
    Location();
    Location(float x, float y, float height);

    /// <summary>
    /// Sets the location.
    /// </summary>
    /// <param name="x">The x position win world coordinates in [km].</param>
    /// <param name="y">The y position win world coordinates in [km].</param>
    /// <param name="height">Target height in [km].</param>
    void SetLocation(float x, float y, float height);

    /// <summary>
    /// Sets the location angular.
    /// </summary>
    /// <param name="distance">The distance.</param>
    /// <param name="azimuth">The azimuth.</param>
    /// <param name="elevation">The elevation.</param>
    void SetLocationAngular(float distance, float azimuth, float elevation);

    float GetX();
    float GetY();
    float GetHeight();

    float GetDistance();
    float GetAzimuth();
    float GetElevation();

    void ToAngular();
    void ToCartesian();

private:
    float _x;
    float _y;
    float _h;
    float _distance;
    float _azimuth;
    float _elevation;
};

