//
// TouchScreen.cpp
//

#include "TouchScreen.h"

//Serial pc(USBTX, USBRX);

TouchScreen::TouchScreen(Display* display)
{
    _width = display != NULL ? display->DisplayWidth() - 1: 479;
    _height =  display != NULL ? display->DisplayHeight() - 1: 271;
}


void TouchScreen::Init()
{
    TS_DISCO_F746NG::Init(_width, _height);
}


pPoint TouchScreen::DetectTouch()
{
    GetState(&tsState);
    // Debug message
    //pc.printf(".");
    
    if(tsState.touchDetected > 0) {
        touchPoint.X = tsState.touchX[0];
        touchPoint.Y = tsState.touchY[0];

        // Debug message
        //pc.printf("Touch detected at (%d, %d)\r\n", touchPoint.X, touchPoint.Y);
    
        //ResetTouchData(&tsState);
        return &touchPoint;
    }

    return NULL;
}