//
// Location.cpp
//

#include "Location.h"
#include "math.h"
#include "Commons.h"

Location::Location()
{
    SetLocation(0,0,0);
}

Location::Location(float x, float y, float height)
{
    SetLocation(x, y, height);
}

void Location::SetLocation(float x, float y, float height)
{
    _x = x;
    _y = y;
    _h = height;

    ToAngular();
}

void Location::SetLocationAngular(float distance, float azimuth, float elevation)
{
    _distance = distance;
    _azimuth = azimuth;
    _elevation = elevation;

    ToCartesian();
}

float Location::GetX()
{
    return _x;
}

float Location::GetY()
{
    return _y;
}

float Location::GetHeight()
{
    return _h;
}

float Location::GetDistance()
{
    return _distance;
}

float Location::GetAzimuth()
{
    return _azimuth;
}

float Location::GetElevation()
{
    return _elevation;
}

void Location::ToAngular()
{
    _distance = (float)sqrt(_x * _x + _y * _y + _h * _h);
    if (_distance > 0)
    {
        if (_x >= 0)
            _azimuth = ((float)M_PI_2 - asinf(_y / _distance));
        else
            _azimuth = (float)(M_PI + M_PI_2 + asinf(_y / _distance));
    }
    else
        _azimuth = 0.f;

    _elevation = _distance > 0 ? asinf(_h / _distance) : 0.f;
}

void Location::ToCartesian()
{
    _x = _distance * sinf(_azimuth);
    _y = _distance * cosf(_azimuth);
    _h = _distance * sinf(_elevation);
}


