//
// GeometricPrim.cpp - Geometric primitives class
//

#include "stdlib.h" // for abs
#include "math.h"   // for floor
#include "GeometricPrim.h"


GeometricPrim::GeometricPrim()
{
}


GeometricPrim::~GeometricPrim()
{
}


void GeometricPrim::DrawLine(int startX, int startY, int endX, int endY)
{
    int diffX = (endX - startX);
    int diffY = (endY - startY);
    
    uint32_t _colorMask = GetDrawColor();

    if (abs(diffX) > abs(diffY)) {

        float dy = diffY / (float)diffX;

        if (endX > startX) {
            for (int x = startX; x <= endX; x++) {
                this->DrawPoint(x, (int)floor(startY + dy*(x - startX)), _colorMask);
            }
        }
        else {
            for (int x = startX; x >= endX; x--) {
                this->DrawPoint(x, (int)floor(startY + dy*(x - startX)), _colorMask);
            }
        }
    }

    else {
        float dx = diffX / (float)diffY;
        if (endY > startY) {
            for (int y = startY; y <= endY; y++) {
                this->DrawPoint((int)floor(startX + dx*(y - startY)), y, _colorMask);
            }
        }
        else {
            for (int y = startY; y >= endY; y--) {
                this->DrawPoint((int)floor(startX + dx*(y - startY)), y, _colorMask);
            }
        }
    }
}


void GeometricPrim::DrawCircle(int posX, int posY, uint16_t radius)
{
    int   decision;    /* Decision Variable */
    uint32_t  current_x;   /* Current X Value */
    uint32_t  current_y;   /* Current Y Value */

    decision = 3 - (radius << 1);
    current_x = 0;
    current_y = radius;
    
    uint32_t _colorMask=GetDrawColor();

    while (current_x <= current_y)
    {
        DrawPoint((posX + current_x), (posY - current_y), _colorMask);

        DrawPoint((posX - current_x), (posY - current_y), _colorMask);

        DrawPoint((posX + current_y), (posY - current_x), _colorMask);

        DrawPoint((posX - current_y), (posY - current_x), _colorMask);

        DrawPoint((posX + current_x), (posY + current_y), _colorMask);

        DrawPoint((posX - current_x), (posY + current_y), _colorMask);

        DrawPoint((posX + current_y), (posY + current_x), _colorMask);

        DrawPoint((posX - current_y), (posY + current_x), _colorMask);

        if (decision < 0)
        {
            decision += (current_x << 2) + 6;
        }
        else
        {
            decision += ((current_x - current_y) << 2) + 10;
            current_y--;
        }
        current_x++;
    }
}


void GeometricPrim::DrawRectangle(int startX, int startY, int endX, int endY)
{
    DrawLine(startX, startY, startX, endY);
    DrawLine(startX, endY, endX, endY);
    DrawLine(endX, endY, endX, startY);
    DrawLine(endX, startY, startX, startY);
}


void GeometricPrim::DrawTriangle(int x1, int y1, int x2, int y2, int x3, int y3)
{
    DrawLine(x1, y1, x2, y2);
    DrawLine(x2, y2, x3, y3);
    DrawLine(x3, y3, x1, y1);
}
