/*
    GrFont.h - System font wrapper class

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"),
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#pragma once

#include "mbed.h"
#include "stm32746g_discovery_lcd.h"

/**
 * GrFontType defines available font types
 */
typedef enum  {
    // Used for array indexes!  Don't change the numbers!
    Courier8 = 0,
    Courier12 = 1,
    Courier16 = 2,
    Courier20 = 3,
    Courier24 = 4,
    FontsNumber
} GrFontType;


/**
 *  @brief System font definition class
 *  to keep system fonts sFONT isolated.
 *  Class will be usefull to handle custom defined fonts.
 */
class GrFont
{

public:
    /**
    * @brief Constructor sets system font of size 12 as a default font.
    */
    GrFont();
    
    /**
    * @brief Constructor sets font of type defined by GrFontType (enum EGrFont).
    */
    GrFont(GrFontType fontType);

    /**
    * @brief Get a reference to original system font.
    */
    sFONT * GetSystemFont();

    /**
    * @brief Change selected font.
    */
    void SetFontType(GrFontType fontType);

    /**
    * @brief Get selected font width in pixels.
    */
    uint16_t Width();
    
    /**
    * @brief Get selected font height in pixels.
    */
    uint16_t Height();

private:

    static const sFONT * _fontType[FontsNumber];
  
    GrFontType _fontTypeSelected;
};
