//
// GrFont.cpp - System font wrapper class
//

#include "GrFont.h"
#include "stm32746g_discovery_lcd.h"

/*******************************************************************************
 * Definition of fonts provided by stm32746g_discovery_lcd driver
 ******************************************************************************/
const sFONT * GrFont::_fontType[FontsNumber] = { &Font8, &Font12, &Font16, &Font20, &Font24 };

GrFont::GrFont()
{
    SetFontType(Courier12);
}


GrFont::GrFont(GrFontType fontType)
{
    SetFontType(fontType);
}


uint16_t GrFont::Width()
{
    return _fontType[_fontTypeSelected]->Width;
}

uint16_t GrFont::Height()
{
    return _fontType[_fontTypeSelected] -> Height;
}


void GrFont::SetFontType(GrFontType fontType)
{
    if(fontType < FontsNumber) {
        _fontTypeSelected = fontType;
    }
}


sFONT *GrFont::GetSystemFont()
{
    return (sFONT *)_fontType[_fontTypeSelected];
}



