/*
    GeometricPrimBase.h - Geometric primitives base class declaration

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"), 
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR 
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#pragma once

#include "stdint.h" // for uint32_t, uint16_t, uint8_t;

class GeometricPrimBase
{
public:
    /// <summary>
    /// Draws the point.
    /// </summary>
    /// <param name="posX">The position x.</param>
    /// <param name="posY">The position y.</param>
    /// <param name="colorMask">The color mask.</param>
    void virtual DrawPoint(int posX, int posY, uint32_t colorMask) = 0;
    
    //void SetDrawColorMask(uint32_t color) = 0;
    
    uint32_t virtual GetDrawColor() = 0;

    /// <summary>
    /// Draws the line.
    /// </summary>
    /// <param name="startX">The start x.</param>
    /// <param name="startY">The start y.</param>
    /// <param name="endX">The end x.</param>
    /// <param name="endY">The end y.</param>
    void virtual DrawLine(int startX, int startY, int endX, int endY) = 0;

    /// <summary>
    /// Draws the circle.
    /// </summary>
    /// <param name="posX">The position x.</param>
    /// <param name="posY">The position y.</param>
    /// <param name="radius">The radius.</param>
    void virtual DrawCircle(int posX, int posY, uint16_t radius) = 0;

    /// <summary>
    /// Draws the rectangle.
    /// </summary>
    /// <param name="startX">The start x.</param>
    /// <param name="startY">The start y.</param>
    /// <param name="endX">The end x.</param>
    /// <param name="endY">The end y.</param>
    void virtual DrawRectangle(int startX, int startY, int endX, int endY) = 0;

    /// <summary>
    /// Draws the triangle.
    /// </summary>
    /// <param name="x1">The x1.</param>
    /// <param name="y1">The y1.</param>
    /// <param name="x2">The x2.</param>
    /// <param name="y2">The y2.</param>
    /// <param name="x3">The x3.</param>
    /// <param name="y3">The y3.</param>
    void virtual DrawTriangle(int x1, int y1, int x2, int y2, int x3, int y3) = 0;
};

