/*
Angle.h - Calculate rotation angle

Copyright(c) 2016 karpent at gmail.com, MIT License

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#pragma once

typedef enum EAngleDirection {
    DirectionLeft = 0,
    DirectionRight = 1
} AngleDirection;


typedef enum EAngleType {
    AngleFixed = 0,
    AngleSham = 1,
    AngleReal = 2
} AngleType;

/**
  * @brief  Calculate rotation angle.
  * Use method GetAngle() to get simulated rotation angle.
  * Use method ReadAngle() if you have additional hadware attached to the board, 
  * it reads the rotation angle from a potentiometer.
  */
class Angle
{
public:

    Angle();
    
    void SetAngle(AngleType type, float initialValue, AngleDirection direction, float delta);

    /// <summary>
    /// Gets the simulated angle value in degrees.
    /// </summary>
    /// <returns>Angle value in degrees.</returns>
    float GetAngle();
    
    void ChangeDirection() {
        _direction = _direction == DirectionLeft ? DirectionRight : DirectionLeft;
        };

protected:

    /// <summary>
    /// Reads the rotation angle from a potentiometer attached to pin A0
    /// </summary>
    /// <returns>Angle value in degrees.</returns>
    float ReadAngle();
    
private:

    AngleDirection _direction;
    
    AngleType _type;
    
    /// <summary>
    /// Actual rotation angle value in degrees, range: 0 - 360
    /// </summary>
    float _angle;

    float _delta;
};