//
// Pyramid.cpp - example of usage graphics commands to create 3D graphics.
//
// This example is based on code written by
// Fabio de Albuquerque Dela Antonio (fabio914 at gmail.com)
// See : https://github.com/fabio914/arduinogl/blob/master/examples
//

#include "Pyramid.h"

// Constructor
Pyramid::Pyramid(Display * display) : Model()
{
    glUseCanvas(display);
}

/**
* @brief  Model setup.
* @retval None
*/
void Pyramid::Setup()
{
    SetFixedScaleMode(2.5);
    
    glPointSize(4);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();

    gluPerspective(30.0, 1.7647f, 0.1f, 9999.f);

    glMatrixMode(GL_MODELVIEW);
}

/**
* @brief  Renders a model for given view angle and scale.
* @param  None
* @retval None
*/
void Pyramid::Render()
{
    float scale = GetScaleValue();
    
    glLoadIdentity();
    gluLookAt(10, 8, -10, 0, 0, 0, 0, 1, 0);

    glRotatef(GetAngleValue(), 0.f, 1.f, 0.f);
    glScalef(scale, scale, scale);

    DrawModel();
}



void Pyramid::DrawModel()
{

    /* 3 triangles instead of 4 */
    glBegin(GL_TRIANGLE_STRIP);
    glVertex3f(-1, -1, -1);
    glVertex3f(1, -1, -1);
    glVertex3f(0, 1, 0);
    glVertex3f(1, -1, 1);
    glVertex3f(-1, -1, 1);
    glEnd();

    glBegin(GL_POLYGON);
    glVertex3f(-1, -1, 1);
    glVertex3f(1, -1, 1);
    glVertex3f(1, -1, -1);
    glVertex3f(-1, -1, -1);
    glEnd();
}