//
// Model.h - abstract class for 3D demo models
//

#pragma once

#include "Angle.h"
#include "Scale.h"

class Model
{
public:

    Model();
    
    void SetShamAngleMode();
    
    void SetRealAngleMode(float initialValue);
    
    float GetAngleValue();

 
    void SetFixedScaleMode(float scale); 
    
    void SetShamScaleMode(float initialValue, float minValue, float maxValue, float delta);  
     
    void SetRealScaleMode(float minValue, float maxValue, float delta);
       
    float GetScaleValue();
    
    void virtual Setup() = 0;
    
    void virtual Render() = 0;
    
private:
    Angle _angle;
    Scale _scale;
};
